clear all, clc

%add folder path and filename
myfolder='';
filename='Plot profile';
pixelsize=2.5; %in nm

%load file in
A=readmatrix([myfolder,'/',filename,'.csv']);
B=autocorr(A(:,2),length(A(:,2))-1);


compixelsize=['pixelsize=', num2str(pixelsize),' ', 'nm'];

plot([1:length(B)]'*pixelsize,B(:,1));
hold on

set(gca,'fontname','arial')
hold off;
xlabel('Lag (nm)');
ylabel('ACF (a.u.)');
ylim([-0.5, 1])
xlim([0,1000])
xticks(0:200:1000)
title({'Autocorrelation of SRC-Halo'});

set(gca,'FontSize', 15)

%save figure to path
saveas(figure(1),fullfile(myfolder,[filename,'_','ACF-lag[nm]-plot','_',compixelsize,'.png']))
saveas(figure(1),fullfile(myfolder,[filename,'_','ACF-lag[nm]-plot','_',compixelsize,'.fig']))
saveas(figure(1),fullfile(myfolder,[filename,'_','ACF-lag[nm]-plot','_',compixelsize,'.pdf']))

%saveas(figure(1),fullfile(myfolder,[filename,'_','histogram of distance between rings','_',compixelsize,'_',comn,'_',commean,'.png']))
%saveas(figure(1),fullfile(myfolder,[filename,'_','histogram of distance between rings','_',compixelsize,'_',comn,'_',commean,'.fig']))

%save .csv to path
G=[[1:length(B)]'*pixelsize,B(:,1)];

dlmwrite(fullfile(myfolder,[filename,'_','ACF-lag[nm]-plot','_',compixelsize,'.csv']),G);

disp('Done');